//
//  MCTimeZoneLocationManager.h
//  MCFoundation
//
//  Created by Eugene Kwong on 2014-10-08.
//
//

#import <Foundation/Foundation.h>

@interface MCTimeZoneLocationManager : NSObject {
    @private
    NSArray *timeZoneLocationInfo;
    
    @public
    NSArray *allTimeZoneLocations;
}

@property (readonly, nonatomic, retain) NSArray *allTimeZoneLocations;

+ (MCTimeZoneLocationManager *)sharedManager;

@end

@interface MCTimeZoneLocation : NSObject {
    NSString *timeZoneID;
    NSString *cityDisplayName;
}

+ (MCTimeZoneLocation*)locationWithID:(NSString*)timeZoneID displayName:(NSString*)name;

@property (readonly, nonatomic, strong) NSString* timeZoneID;
@property (readonly, nonatomic, strong) NSString* cityDisplayName;

@end
